#import <Foundation/Foundation.h>
#import <CallKit/CallKit.h>
#import "SINClientMediator+Private.h"
#import "SINJWT.h"
#import "Config.h"

@implementation SINClientMediator (SINClientDelegate)

- (void)client:(id<SINClient>)client requiresRegistrationCredentials:(id<SINClientRegistration>)registrationCallback {
  // WARNING: Embedding the Application Secret and use of the class SINJWT as shown here
  // should NOT be done for an application deployed to production.
  // The class SINJWT is only here to show how to construct and sign a registration token.

  NSString *jwt = [SINJWT jwtForUserRegistrationWithApplicationKey:APPLICATION_KEY
                                                 applicationSecret:APPLICATION_SECRET
                                                            userId:self.client.userId];

  [registrationCallback registerWithJWT:jwt];
}

- (void)clientDidStart:(id<SINClient>)client {
  os_log(self.customLog, "Sinch client started successfully (version: %{public}@)", [Sinch versionString]);

  [[NSUserDefaults standardUserDefaults] setValue:client.userId forKey:userIDKey];
  [[NSUserDefaults standardUserDefaults] synchronize];

  if (self.clientCreatedCallback != nil) {
    self.clientCreatedCallback(nil);
    self.clientCreatedCallback = nil;
  }
}

- (void)clientDidFail:(id<SINClient>)client error:(NSError *)error {
  os_log_error(self.customLog, "Sinch client error: %{public}@", [error localizedDescription]);

  self.client = nil;

  if (self.clientCreatedCallback != nil) {
    self.clientCreatedCallback(error);
    self.clientCreatedCallback = nil;
  }
}

@end
