#import "SinchDefaultButton.h"

static const CGFloat minimalWidth = 160.0;
static const CGFloat widthAddition = 2 * 20.0;

@implementation SinchDefaultButton

- (instancetype)initWithFrame:(CGRect)frame {
  self = [super initWithFrame:frame];
  if (self != nil) {
    [self setup];
  }
  return self;
}

- (instancetype)initWithCoder:(NSCoder*)coder {
  self = [super initWithCoder:coder];
  if (self != nil) {
    [self setup];
  }
  return self;
}

- (void)awakeFromNib {
  [super awakeFromNib];

  if (self.backgroundColor == nil) {
    self.backgroundColor = [UIColor colorNamed:@"sinchDefaultButtonColor"];
    self.tintColor = [UIColor colorNamed:@"sinchDefaultButtonTextColor"];
  }
}

- (void)setup {
  self.titleLabel.font = [UIFont fontWithName:@"Helvetica Bold" size:20.0];

  self.layer.borderWidth = 1.0;
  self.layer.borderColor = UIColor.clearColor.CGColor;
  self.layer.cornerRadius = self.bounds.size.height / 2.0;
}

- (CGSize)intrinsicContentSize {
  CGSize size = [super intrinsicContentSize];
  const CGFloat newWidth = size.width + widthAddition;
  size.width = MAX(newWidth, minimalWidth);
  return size;
}

@end
