#import "MainViewController.h"

// This category for the MainViewController serves only to separate code that
// is directly related to the usage of the Sinch SDK, from code that is used
// for improving the look and feel of the sample app.

// Nothing magic here, just regular code interacting with the iOS SDK.

@interface MainViewController (UI) <UITextFieldDelegate>

@end

@implementation MainViewController (UI)

- (void)viewDidLoad {
  [super viewDidLoad];
  self.destination.delegate = self;
}

- (IBAction)dismissKeyboard:(UITapGestureRecognizer *)recognizer {
  [self.view endEditing:YES];
}

- (void)viewWillAppear:(BOOL)animated {
  [super viewWillAppear:animated];
  [self.destination becomeFirstResponder];
  self.callButton.enabled = self.destination.text != nil && self.destination.text.length > 0;
  self.notificationLabel.text = @"";
}

- (BOOL)textField:(UITextField *)textField
    shouldChangeCharactersInRange:(NSRange)range
                replacementString:(NSString *)string {
  NSString *newText = [self.destination.text stringByReplacingCharactersInRange:range withString:string];
  self.callButton.enabled = newText.length > 0;
  return YES;
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
  if (self.destination.text.length > 0) {
    dispatch_async(dispatch_get_main_queue(), ^{
      [self call:self.callButton];
    });
    [textField resignFirstResponder];
  }
  return YES;
}

@end
