#import "LoginViewController.h"
#import "LoginViewController+UI.h"

@implementation LoginViewController (UI)

- (IBAction)dismissKeyboard:(UITapGestureRecognizer *)recognizer {
  [self.view endEditing:YES];
}

- (BOOL)textField:(UITextField *)textField
    shouldChangeCharactersInRange:(NSRange)range
                replacementString:(NSString *)string {
  NSString *newText = [self.nameTextField.text stringByReplacingCharactersInRange:range withString:string];
  self.loginButton.enabled = newText.length > 0;
  return YES;
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
  if (self.nameTextField.text.length > 0) {
    dispatch_async(dispatch_get_main_queue(), ^{
      [self login:self.loginButton];
    });
    [textField resignFirstResponder];
  }
  return YES;
}

@end
