#include <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * Helper class showing how to create a signed JWT (JSON Web Token)
 * for User registration (@see SINClientRegistration).
 *
 * IMPORTANT: This implementation here in the sample app is only here
 * to quickly get you started with the samples apps and this
 * implementation is NOT meant to be used in production. When
 * deploying your application to production, the Application Secret
 * should be kept secure on your backend and not be embedded in the
 * sample apps.
 */
@interface SINJWT : NSObject

+ (NSString *)jwtForUserRegistrationWithApplicationKey:(NSString *)applicationKey
                                     applicationSecret:(NSString *)applicationSecret
                                                userId:(NSString *)userId;

+ (NSString *)jwtForUserRegistrationWithApplicationKey:(NSString *)applicationKey
                                     applicationSecret:(NSString *)applicationSecret
                                                userId:(NSString *)userId
                                                 nonce:(NSString *)nonce
                                              issuedAt:(NSDate *)issuedAt
                                              expireAt:(NSDate *)expireAt;

+ (NSString *)jwtForUserRegistrationWithApplicationKey:(NSString *)applicationKey
                                     applicationSecret:(NSString *)applicationSecret
                                                userId:(NSString *)userId
                                                 nonce:(NSString *)nonce
                                              issuedAt:(NSDate *)issuedAt
                                              expireAt:(NSDate *)expireAt
                                      instanceExpireAt:(NSDate *)instanceExpireAt;

@end

NS_ASSUME_NONNULL_END
