#import "SINCallRegistry.h"

@interface SINCallRegistry ()

@property (nonatomic, strong) NSMutableDictionary<NSString *, id<SINCall>> *activeCalls;
@property (nonatomic, strong) NSMutableDictionary<NSString *, NSUUID *> *mapCallIdToCallKitId;

@end

@implementation SINCallRegistry

- (instancetype)init {
  self = [super init];

  if (self) {
    self.activeCalls = [NSMutableDictionary dictionary];
    self.mapCallIdToCallKitId = [NSMutableDictionary dictionary];
  }

  return self;
}

- (void)reset {
  @synchronized(self) {
    [self.activeCalls removeAllObjects];
    [self.mapCallIdToCallKitId removeAllObjects];
  }
}

- (void)addSinchCall:(id<SINCall>)call {
  @synchronized(self) {
    self.activeCalls[call.callId] = call;
  }
}

- (void)removeSinchCallWithId:(NSString *)callId {
  @synchronized(self) {
    [self.activeCalls removeObjectForKey:callId];
    [self.mapCallIdToCallKitId removeObjectForKey:callId];
  }
}

- (id<SINCall>)sinchCallForCallId:(NSString *)callId {
  @synchronized(self) {
    return self.activeCalls[callId];
  }
}

- (id<SINCall>)sinchCallForCallKitUUID:(NSUUID *)uuid {
  @synchronized(self) {
    NSSet *keys = [self.mapCallIdToCallKitId
        keysOfEntriesPassingTest:^BOOL(NSString *_Nonnull key, NSUUID *_Nonnull obj, BOOL *_Nonnull stop) {
          *stop = [uuid isEqual:obj];
          return *stop;
        }];

    if (keys.count > 0) {
      return self.activeCalls[keys.allObjects[0]];
    }
    return nil;
  }
}

- (NSArray<id<SINCall>> *)activeSinchCalls {
  @synchronized(self) {
    return self.activeCalls.allValues;
  }
}

- (void)mapCallKitUUID:(NSUUID *)uuid toSinchCallId:(NSString *)callId {
  @synchronized(self) {
    self.mapCallIdToCallKitId[callId] = uuid;
  }
}

- (NSUUID *)callKitUUIDForSinchId:(NSString *)callId {
  @synchronized(self) {
    return self.mapCallIdToCallKitId[callId];
  }
}

@end
