#import "SINClientMediator.h"
#import <Sinch/Sinch.h>
#import "AudioControllerDelegate.h"
#import "SINCallRegistry.h"

NS_ASSUME_NONNULL_BEGIN

FOUNDATION_EXTERN NSString *const userIDKey;

@interface SINClientMediator ()
@property (nonatomic, readwrite, weak) id<SINClientMediatorDelegate> delegate;
@property (nonatomic, readwrite, strong) _Nullable id<SINClient> client;
@property (nonatomic, readwrite, strong) os_log_t customLog;

@property (nonatomic, readwrite, strong) AudioControllerDelegate *acDelegate;
@property (nonatomic, readwrite, strong) SINCallRegistry *callRegistry;
@property (nonatomic, readwrite, strong) CXProvider *provider;
@property (nonatomic, readwrite, strong) CXCallController *callController;

@property (nonatomic, readwrite, strong) _Nullable ErrorCompletion clientCreatedCallback;
@property (nonatomic, readwrite, strong) _Nullable CallStartedCompletion callStartedCallback;
@property (nonatomic, assign) BOOL isVideo;
@property (nonatomic, strong, readonly) NSPointerArray *observers;

- (void)fanoutDelegateCallWithCallback:(void (^)(id observer))callback;
@end

#pragma mark - SINCallDelegate
@interface SINClientMediator (SINCallDelegate) <SINCallDelegate>
@end

#pragma mark - CXProviderDelegate
@interface SINClientMediator (CXProviderDelegate) <CXProviderDelegate>
@end

NS_ASSUME_NONNULL_END
