#import "LoginViewController.h"
#import "LoginViewController+UI.h"
#import "SINClientMediator.h"
#import "CallViewController.h"
#import "MainViewController.h"
#import "Config.h"

@implementation LoginViewController

- (void)viewDidLoad {
  [super viewDidLoad];
  self.loginButton.enabled = NO;
  self.notificationLabel.numberOfLines = 10;
  [self.nameTextField becomeFirstResponder];
  self.nameTextField.delegate = self;

  if ([APPLICATION_SECRET isEqual:@"<APPLICATION SECRET>"] || [APPLICATION_KEY isEqual:@"<APPLICATION KEY>"]) {
    self.notificationLabel.text = @"APPLICATION KEY and SECRET must be set to valid values in Config.m";
    self.nameTextField.enabled = NO;
  }
}

- (IBAction)login:(UIButton *)sender {
  self.notificationLabel.text = @"";
  self.loginButton.enabled = NO;

  NSAssert(self.callKitMediator != nil, @"self.callKitMediator must not be nil here", @"");

  NSString *userId = self.nameTextField.text;
  [self.callKitMediator createClientWithUserId:userId
                                    completion:^(NSError *_Nullable error) {
                                      if (error == nil) {
                                        [self performSegueWithIdentifier:@"mainView" sender:nil];
                                      } else {
                                        self.notificationLabel.text = error.localizedDescription;
                                      }
                                      dispatch_async(dispatch_get_main_queue(), ^{
                                        self.loginButton.enabled = YES;
                                      });
                                    }];
}

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(nullable id)sender {
  // If a push notification was received which led to the application being started, the may have a transition from
  // the login view controller directly to an incoming call view controller.
  if ([[segue identifier] isEqualToString:@"callView"]) {
    CallViewController *callViewController = [segue destinationViewController];
    callViewController.call = sender;
    callViewController.callKitMediator = self.callKitMediator;

  } else if ([[segue identifier] isEqualToString:@"mainView"]) {
    MainViewController *mainViewController = [segue destinationViewController];
    mainViewController.callKitMediator = self.callKitMediator;
  }
}

@end
