#import <Foundation/Foundation.h>
#import <Sinch/Sinch.h>

NS_ASSUME_NONNULL_BEGIN

@interface SINCallRegistry : NSObject

- (void)reset;

#pragma mark - SinchCall API
- (void)addSinchCall:(id<SINCall>)call;
- (void)removeSinchCallWithId:(NSString *)callId;
- (id<SINCall>)sinchCallForCallId:(NSString *)callId;
- (id<SINCall>)sinchCallForCallKitUUID:(NSUUID *)uuid;
- (NSArray<id<SINCall>> *)activeSinchCalls;

#pragma mark - CallKit <-> Sinch CallId mapping API
// This is necessary to properly bind Callkit UUID and sinch callId when making calls
- (void)mapCallKitUUID:(NSUUID *)uuid toSinchCallId:(NSString *)callId;
- (NSUUID *)callKitUUIDForSinchId:(NSString *)callId;

@end

NS_ASSUME_NONNULL_END
