#import <Foundation/Foundation.h>
#import <CallKit/CallKit.h>
#import "SINClientMediator+Private.h"

@implementation SINClientMediator (SINCallClientDelegate)

- (void)client:(id<SINCallClient>)client didReceiveIncomingCall:(id<SINCall>)call {
  const UIApplicationState state = [[UIApplication sharedApplication] applicationState];

  os_log(self.customLog, "didReceiveIncomingCall with callId: %{public}@, from:%{public}@, app state:%{public}d",
         call.callId, call.remoteUserId, (int)state);

  // NOTE: Mediator is the only delegate of the call and will do the fanout of events
  call.delegate = self;
  // We save the call object so we can either accept or deny it later when user interacts with CallKit UI
  [self.callRegistry addSinchCall:call];

  if (state != UIApplicationStateBackground) {
    [self.delegate handleIncomingCall:call];
  }
}

@end
