#import "MainViewController.h"
#import "CallViewController.h"
#import "SINClientMediator.h"

@implementation MainViewController

- (void)callUserWithId:(NSString *)destination {
}

- (IBAction)call:(UIButton *)sender {
  sender.enabled = NO;
  self.notificationLabel.text = @"";

  NSAssert(self.callKitMediator != nil, @"self.callKitMediator must not be nil here", @"");
  NSAssert(self.callKitMediator.client != nil, @"self.callKitMediator.client must not be nil here", @"");

  [self.callKitMediator startOutgoingCallTo:self.destination.text
                                 completion:^(id<SINCall> _Nullable call, NSError *_Nullable error) {
                                   if (error == nil) {
                                     [self performSegueWithIdentifier:@"callView" sender:call];
                                   } else {
                                     self.notificationLabel.text = error.localizedDescription;
                                   }

                                   sender.enabled = YES;
                                 }];
}

- (IBAction)logout:(id)sender {
  [self.callKitMediator logout:^{
    [self dismissViewControllerAnimated:YES completion:nil];
  }];
}

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(nullable id)sender {
  if ([[segue identifier] isEqualToString:@"callView"]) {
    CallViewController *callViewController = [segue destinationViewController];
    callViewController.call = sender;
    callViewController.callKitMediator = self.callKitMediator;
  }
}

@end
