package com.sinch.android.rtc.sample.hmspush

import android.util.Log
import com.sinch.android.rtc.PushTokenUnregistrationCallback
import com.sinch.android.rtc.SinchError

/**
 * Basic implementation of [PushTokenUnregistrationCallback] that logs the unregistration
 * result to console output.
 */
class SimplePushTokenUnregistrationCallback : PushTokenUnregistrationCallback {
    override fun onPushTokenUnregistered() {
        Log.d(TAG, "Successfully unregistered Push Token!")
    }

    override fun onPushTokenUnregistrationFailed(error: SinchError) {
        Log.e(TAG, "Unregistration of the Push Token failed! " + error.message)
    }

    companion object {
        var TAG: String = SimplePushTokenUnregistrationCallback::class.java.simpleName
    }
}