package com.sinch.android.rtc.sample.video.push

import android.content.Context
import android.content.SharedPreferences

object FcmTokenPersistence {

    private const val PREF_NAME = "fcmTokenPersistence"
    private const val FCM_TOKEN = "fcmRegToken"

    private fun getSharedPref(context: Context): SharedPreferences {
        return context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE)
    }

    fun getFcmRegistrationToken(context: Context): String? {
        return getSharedPref(context).getString(FCM_TOKEN, null)
    }

    fun setFcmRegistrationToken(context: Context, token: String?) {
        getSharedPref(context).edit().putString(FCM_TOKEN, token).commit()
    }
}