package com.sinch.android.rtc.sample.hmspush

import android.content.Context
import android.content.SharedPreferences

object PersistedHmsRegistration {

    private const val PREF_NAME = "persistedHmsRegistrationData"
    private const val HMS_TOKEN = "hmsToken"
    private const val HMS_APP_ID = "hmsAppId"

    private fun getSharedPref(context: Context): SharedPreferences {
        return context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE)
    }

    fun getHmsToken(context: Context): String? {
        return getSharedPref(context).getString(HMS_TOKEN, "")
    }

    fun setHmsToken(context: Context, token: String?) {
        getSharedPref(context).edit().putString(HMS_TOKEN, token).commit()
    }

    fun getHmsApplicationId(context: Context): String? {
        return getSharedPref(context).getString(HMS_APP_ID, "")
    }

    fun setHmsApplicationId(context: Context, id: String?) {
        getSharedPref(context).edit().putString(HMS_APP_ID, id).commit()
    }
}